module.exports = function (blocks) {
    'use strict';
    blocks.declare('debug', data => {
        const excludedFields = [];

        if (!data.debug) {
            return false;
        }

        excludedFields.forEach(field => {
            delete data[field];
        });

        return {
            block: 'debug',
            tag: 'section',
            content: JSON.stringify(data, null, 4)
        };
    });
};
