/* global BEM */
BEM.DOM.decl('exam-start', {
    onSetMod: {
        js: function () {
            'use strict';
            this._startButton = this.findBlockInside('start', 'button2');
            this._checkbox = this.findBlockInside('checkbox');
            this._termsModal = this.findBlockInside({ blockName: 'modal', modName: 'type', modVal: 'terms' });
            this._bPage = this.findBlockOutside('b-page');
            this._close = this._termsModal && this._termsModal.findElem('close');

            this.bindEvents();
        }
    },

    bindEvents: function () {
        /* eslint-disable no-unused-expressions */
        'use strict';
        if (this.params.isAuthorized) {
            this.bindToDomElem(this._startButton.domElem, 'click', this._onStartClick.bind(this));
            this._checkbox && this._checkbox.on('change', this._onCheckboxChange.bind(this));
            this._termsModal && this._termsModal.on('beforeClose', this._onTermsModalClose.bind(this));
            this._close && this.bindTo(this._close, 'pointerclick', this._closeModal.bind(this));
        }
    },

    _onStartClick: function (e) {
        'use strict';
        if (this._checkbox) {
            if (!this._checkbox.isChecked()) {
                e.preventDefault();
                this._checkbox.setMod('error', 'yes');

                return;
            }

            if (this._termsModal) {
                this._startButton.setMod('disabled', 'yes');
                this._checkbox.setMod('disabled', 'yes');
                this._termsModal.setMod('visible', 'yes');
                this._bPage.setMod('hide-scroll', 'yes');
            }
        }
    },

    _onCheckboxChange: function () {
        'use strict';
        if (this._checkbox.isChecked()) {
            this._checkbox.delMod('error');
        }
    },

    _onTermsModalClose: function () {
        this._startButton.delMod('disabled');
        this._checkbox.delMod('disabled');
        this._bPage.delMod('hide-scroll');
    },

    _closeModal: function () {
        this._termsModal.delMod('visible');
    }
});
