module.exports = function (bh) {
    'use strict';
    bh.match('faq', function (ctx, json) {
        ctx.content([
            json.faq && {
                elem: 'title',
                mix: { block: 'content', elem: 'title' },
                content: json.faq.title
            },
            json.faq && {
                elem: 'text',
                mix: { block: 'html-content' },
                content: bh.lib.util.template(json.faq.text)
            }
        ]);
    });

    bh.match('faq__title', function (ctx) {
        ctx.tag('h1');
    });
};
