module.exports = function (bh) {
    'use strict';
    bh.match('feature', function (ctx, json) {
        var feature = json.feature;

        if (!feature) {
            return '';
        }

        ctx
            .tParam('feature', feature)
            .content({ elem: 'wrapper' });
    });

    bh.match('feature__wrapper', function (ctx) {
        var feature = ctx.tParam('feature');

        ctx.content([
            { elem: 'image' },
            { elem: 'title', content: feature.title },
            {
                elem: 'description',
                mix: { block: 'html-content' },
                content: feature.text
            }
        ]);
    });

    bh.match([
        'feature__title',
        'feature__description'
    ], function (ctx, json) {
        ctx.content(json.content);
    });

    bh.match('feature__description', function (ctx) {
        var feature = ctx.tParam('feature');

        ctx.content(feature.text);
    });

    bh.match('feature__image', function (ctx) {
        var feature = ctx.tParam('feature');

        ctx.content({
            elem: 'img',
            tag: 'img',
            attrs: {
                src: feature.image,
                title: feature.title,
                alt: feature.title
            }
        });
    });
};
