/* global BEM, BH */
BEM.DOM.decl('i-bem', {}, {
    createErrorMessage: function (error, key, defaultKey) {
        'use strict';
        var internalCode = error && error.responseJSON && error.responseJSON.internalCode;
        var defaultText = BH.lib.i18n('errors', defaultKey || 'default');
        var reason = (internalCode && BH.lib.i18n('errors', internalCode)) || defaultText;

        return BH.lib.i18n('errors', key, { reason: reason });
    },

    /**
     * Скейл айфреймов в мобильный версии
     * @param {Object} context
     */
    touchIframeFix: function (context) {
        if (!BH.lib.global.isMobile) {
            return;
        }

        var iframes = $(context.domElem.find('iframe'));

        // Оборачиваем все iframe в div
        $.each(iframes, function (_, iframe) {
            var $wrapper = $('<div class="touch-iframe-wrapper"></div>');

            var $iframe = $(iframe);

            $iframe.css('transform-origin', 'top left');
            $iframe.wrap($wrapper);
        });

        // Перезапускаем масштабирование при изменении размеров экрана и смене ориентации
        context.bindTo($(window), 'orientationchange resize',
            this._scaleIframes.bind(this, iframes));

        this._scaleIframes(iframes);
    },

    _scaleIframes: function (iframes) {
        iframes.each(function (_, iframe) {
            var $iframe = $(iframe);
            var $wrapper = $iframe.parent();
            var wrapperParentWidth = this._getVisibleParentWidth($wrapper);
            var iframeWidth = $iframe.outerWidth();

            var scale = 1;
            var width = 'auto';
            var height = 'auto';

            // Если iframe шире чем viewport, вычисляем коэффициент масштабирования
            if (wrapperParentWidth < iframeWidth) {
                scale = wrapperParentWidth / iframeWidth;
                width = wrapperParentWidth;
                height = $iframe.outerHeight() * scale;
            }

            // Переносим все отступы с iframe на wrapper
            if ($iframe.innerHeight() > $iframe.height()) {
                $wrapper.css('padding', $iframe.css('padding'));
                $iframe.css('padding', '');
            }

            if ($iframe.css('border')) {
                $iframe.css('border', '');
                $iframe.attr('frameborder', 0);
            }

            if ($iframe.css('margin')) {
                $wrapper.css('margin', $iframe.css('margin'));
                $iframe.css('margin', 0);
            }

            $iframe.css('transform', 'scale(' + scale + ')');
            $wrapper.css({
                width: width,
                height: height
            });
        }.bind(this));
    },

    _getVisibleParentWidth: function (element) {
        var parents = element.parents();
        var allGaps = 0;
        var parentWidth = 0;

        for (var i = 0; i < parents.length; i += 1) {
            var parent = parents[i];
            var isVisible = parent.offsetWidth > 0;
            var parentGap = this._getElementGap($(parent), { withMargin: !isVisible });

            if (isVisible) {
                parentWidth = parent.offsetWidth - parentGap;
                break;
            }

            allGaps += parentGap;
        }

        return parentWidth - allGaps;
    },

    _getElementGap: function (parent, params) {
        var paddingLeft = this._getGap(parent, 'paddingLeft');
        var paddingRight = this._getGap(parent, 'paddingRight');
        var marginLeft = this._getGap(parent, 'marginLeft');
        var marginRight = this._getGap(parent, 'marginRight');

        var paddings = paddingLeft + paddingRight;
        var margins = params && params.withMargin ? marginLeft + marginRight : 0;

        return paddings + margins;
    },

    _getGap: function (parent, gapName) {
        var gapNumber = Number(parent.css(gapName).replace('px', ''));

        if (!gapNumber) {
            return 0;
        }

        return gapNumber;
    }
});
