module.exports = function (bh) {
    'use strict';
    bh.match('iframe-form', function (ctx, json) {
        if (typeof json.formId !== 'string') {
            return '';
        }

        var queryString = [
            'iframe=1',
            'url=' + encodeURIComponent(bh.lib.global.retpath)
        ];

        var params = json.params || [];

        for (var i = 0; i < params.length; i++) {
            var param = params[i];
            queryString.push(param.key + '=' + param.value);
        }

        if (bh.lib.global.isMobile) {
            queryString.push('media-type=mobile');
        }

        var src = 'https://forms.yandex.ru/surveys/' + json.formId + '/?' + queryString.join('&');

        ctx
            .tag('iframe')
            .js(true)
            .attrs({
                src: src,
                frameborder: 0,
                name: 'form-' + json.formId
            });
    });
};
