/* global BEM */
/**
 * Этот блок нужен для налаживания коммуникации с формой посредством postMessage
 * Подробнее об этом можно прочитать здесь:
 * https://github.yandex-team.ru/pages/yandex-events/yandex-tech-api-docs/docs.html#vstraivanie-formyi-v-iframe
 */
BEM.DOM.decl('iframe-form', {
    onSetMod: {
        js: {
            inited: function () {
                'use strict';
                this._iframe = this.domElem;

                this.bindToWin('message', this._onIframeMessage.bind(this));
            }
        }
    },

    _onIframeMessage: function (e) {
        'use strict';
        var data = e.originalEvent.data;

        try {
            data = JSON.parse(data);
        } catch (e) {
            return;
        }

        var source = e.originalEvent.source;

        // iframe anti ClickJacking
        // https://github.yandex-team.ru/pages/yandex-events/yandex-tech-api-docs/docs.html#vstraivanie-formyi-v-iframe
        if (data === 'ping' || data.message === 'ping') {
            source.postMessage('pong', '*');
        }

        // Через postMessage с интервалом в 300мс отправляется высота страницы
        // Меняем высоту iframe
        if (data['iframe-height'] && data.name === this._iframe.attr('name')) {
            this._iframe.height(data['iframe-height']);
        }
    }
});
