module.exports = function (bh) {
    'use strict';
    bh.match('layout', function (ctx, json) {
        var footer = json.footer;

        ctx
            .tag('section')
            .content([
                {
                    elem: 'column',
                    content: [
                        {
                            elem: 'content',
                            left: json.left,
                            right: json.right,
                            content: ctx.content()
                        }
                    ]
                },
                footer && {
                    elem: 'footer',
                    content: footer
                }
            ], true);
    });

    bh.match('layout__content', function (ctx) {
        var left = ctx.param('left');
        var right = ctx.param('right');
        var content = ctx.param('content');

        ctx
            .mod('flex', (left || right) && 'yes')
            .content(content || [
                left && {
                    elem: 'left',
                    data: left
                },
                right && {
                    elem: 'right',
                    data: right
                }
            ]);
    });

    bh.match('layout__left', function (ctx) {
        ctx
            .tag('aside')
            .content(ctx.param('data'));
    });

    bh.match('layout__right', function (ctx) {
        ctx
            .tag('article')
            .content(ctx.param('data'));
    });
};
