module.exports = function (bh) {
    'use strict';
    bh.match('left-menu', function (ctx, json) {
        ctx.content([
            {
                elem: 'title',
                content: [
                    bh.lib.i18n('common', 'menu.title'),
                    {
                        elem: 'beta',
                        content: '&beta;'
                    }
                ]
            },
            {
                elem: 'menu',
                mods: { type: 'exams' },
                items: json.items.exams,
                examId: json.examId,
                examSlug: json.examSlug
            },
            {
                elem: 'menu',
                mods: { type: 'sections' },
                items: json.items.sections,
                page: json.page
            }
        ]);
    });

    bh.match('left-menu__title', function (ctx) {
        ctx.tag('h4');
    });

    bh.match('left-menu__menu', function (ctx) {
        ctx.tag('nav');
    });

    bh.match('left-menu__menu_type_exams', function (ctx, json) {
        ctx.content(json.items.map(function (item) {
            return {
                elem: 'item',
                url: item.url,
                isCurrent: item.id === json.examSlug,
                text: item.name
            };
        }));
    });

    bh.match('left-menu__menu_type_sections', function (ctx, json) {
        ctx.content(json.items.map(function (item) {
            return {
                elem: 'item',
                url: item.url,
                isCurrent: item.id === json.page,
                text: item.name
            };
        }));
    });

    bh.match('left-menu__item', function (ctx, json) {
        ctx.content(json.isCurrent ? json.text : {
            block: 'link',
            mods: { theme: 'expert' },
            text: json.text,
            url: json.url
        });
    });
};
