module.exports = function (bh) {
    'use strict';

    bh.match('level-subscribe_type_form', function (ctx, json) {
        var settings = json.shareLevel;
        var form = settings.form;
        var noSocials = json.noSocials;
        var subscriptionType = 'compact';

        if (!form) {
            return;
        }

        var mode = 'single';

        ctx.content([
            {
                elem: 'form-wrapper',
                elemMods: { socials: noSocials && 'no' },
                content: [
                    {
                        block: 'contact-form',
                        mods: { type: 'compact' },
                        js: {
                            subscriptionType: 'public',
                            url: bh.lib.global.subscribeFormPath,
                            metrikaGoalId: 'form_subscription_' + subscriptionType
                        },
                        fields: form.fields,
                        agreements: form.agreements,
                        compact: true,
                        caption: form.label,
                        button: {
                            text: bh.lib.i18n('forms', 'subscription.button'),
                            align: 'center'
                        },
                        successTitle: bh.lib.i18n('forms', 'subscribed.' + mode + '.title'),
                        successText: bh.lib.i18n('forms', 'subscribed.' + mode + '.text')
                    }
                ]
            },
            !noSocials && [
                {
                    elem: 'splitter'
                },
                {
                    elem: 'button-container',
                    socialNetworks: settings['social-networks']
                }
            ]
        ]);
    });
};
