module.exports = function (bh) {
    'use strict';

    bh.match('level-subscribe', function (ctx) {
        ctx
            .tag('section')
            .js(true)
            .content({
                elem: 'wrapper',
                content: ctx.content()
            }, true);
    });

    bh.match('level-subscribe__button-container', function (ctx, json) {
        var buttons = [];
        var networks = json.socialNetworks;

        var networkNames = Object.keys(networks);

        networkNames.sort(function (item1, item2) {
            return networks[item1].order - networks[item2].order;
        });

        networkNames.forEach(function (item) {
            var network = networks[item];

            buttons.push({
                block: 'button',
                mods: {
                    social: item,
                    size: 'xl',
                    theme: 'clear'
                },
                content: json.hasLable ? network.label : '',
                url: network.url
            });
        });

        ctx.content(buttons);
    });

    bh.match('level-subscribe__label', function (ctx) {
        ctx.tag('h3');
    });
};
