BEM.DOM.decl('level-subscribe', {
    onSetMod: {
        js: function () {
            this._findElems();
            this._bindEvents();
        }
    },

    _findElems: function () {
        this._subscriptionButtons = this.findBlocksInside('button-container', 'button');
    },

    _bindEvents: function () {
        this._subscriptionButtons.map(this._bindMetrika.bind(this));
    },

    _bindMetrika: function (button) {
        var mods = button.getMods();

        button.on('click', this._makeMetrikaSubscription(mods.social));
    },

    _makeMetrikaSubscription: function (social) {
        var action = function () {
            if (social) {
                BEM.blocks.metrika.reachGoal('level_subscription_to_' + social);
            }
        };

        return action.bind(this);
    }
});
