module.exports = function (bh) {
    'use strict';
    bh.match('level_type_head', function (ctx, json) {
        var level = json.level;

        ctx.content([
            {
                elem: 'head-image',
                image: level.image,
                content: {
                    elem: 'image-title',
                    content: level.title
                }
            },
            {
                elem: 'head-title',
                content: level.title
            },
            {
                elem: 'head-text',
                content: level.text
            },
            {
                block: 'maintenance',
                maintenance: level.maintenance
            }
        ]);
    });

    bh.match('level__head-image', function (ctx) {
        var mdsImage = ctx.tParam('mdsImage');
        if (mdsImage) {
            ctx.attrs({
                style: 'background-image: url(' + mdsImage + ');'
            });
        }
    });

    bh.match('level__head-title', function (ctx) {
        ctx.tag('h1');
    });
};
