module.exports = function (blocks) {
    'use strict';
    blocks.declare('levels', function (data) {
        const levels = data.content.levels || [];
        const shareLevel = data.shareLevel;

        if (!levels.length && !shareLevel) {
            return;
        }

        const levelsPages = ['index', 'exam-cluster'];
        const page = data.page;

        return {
            block: 'levels',
            mods: {
                page: page,
                'full-page': levelsPages.indexOf(page) > -1
            },
            content: {
                elem: 'content',
                content: [
                    levels && levels.length ? levels.map(function (level) {
                        return {
                            block: 'level',
                            mods: {
                                type: level.type
                            },
                            level: level
                        };
                    }) : null,
                    shareLevel && blocks.exec('level-subscribe', data)
                ]
            }
        };
    });
};
