module.exports = function (bh) {
    var getBreadcrumbsItem = function (item, indexChain) {
        return {
            block: 'main-menu',
            elem: 'breadcrumbs-item',
            content: item.title,
            attrs: {
                'data-chain': indexChain
            }
        };
    };

    var getAdditionalBreadcrumbsItem = function (item) {
        return {
            block: 'main-menu',
            elem: 'breadcrumbs-item',
            content: item.text,
            attrs: {
                'data-url': item.url
            }
        };
    };

    /* eslint-disable max-statements */
    bh.match('main-menu__breadcrumbs', function (ctx, json) {
        var currentItem = json.menu;

        if (!currentItem) {
            return;
        }

        var indexs = json.chain;
        var shouldAddBreadcrumbs = json.shouldAddBreadcrumbs;
        var items = currentItem.additionalBreadcrumbs;

        var content = [getBreadcrumbsItem(currentItem, '')];

        for (var i = 0; i < indexs.length; i += 1) {
            if (currentItem.items && currentItem.items.length > 0) {
                currentItem = currentItem.items[indexs[i]];
            }

            content.push(getBreadcrumbsItem(currentItem, indexs.slice(0, i + 1).join('.')));
        }

        if (shouldAddBreadcrumbs && items) {
            content = content.concat(items.map(function (item) {
                return getAdditionalBreadcrumbsItem(item);
            }));
        }

        ctx.content(content);
    });
};
