module.exports = function (bh) {
    bh.match('main-menu', function (ctx, json) {
        var data = json.data;
        var product = data.product;
        var rightColumn = json.rightColumn;

        ctx.js({
            menu: data.mainMenu,
            breadcrumbsChain: data.breadcrumbsChain,
            phoneData: data.settings && data.settings.prefooter,
            cta: product && product.cta ? product.cta : null
        })
            .content([
                {
                    block: 'head',
                    avatarId: data.blackbox.avatar && data.blackbox.avatar.default,
                    mordaHost: data.mordaHost
                },
                {
                    elem: 'head',
                    data: data,
                    content: [
                        {
                            elem: 'switch',
                            content: [
                                {
                                    elem: 'switch-icon',
                                    content: [
                                        {
                                            elem: 'switch-close'
                                        },
                                        {
                                            elem: 'switch-open'
                                        }
                                    ]
                                },
                                {
                                    elem: 'switch-text'
                                }
                            ]
                        },
                        {
                            elem: 'root-breadcrumbs',
                            items: data.mainMenu.rootBreadcrumbs
                        },
                        {
                            elem: 'breadcrumbs',
                            menu: data.mainMenu,
                            chain: data.breadcrumbsChain,
                            shouldAddBreadcrumbs: true
                        },
                        rightColumn && {
                            elem: 'right-column',
                            content: [rightColumn]
                        },
                        { elem: 'cta' }
                    ]
                }
            ]);
    });
};
