BEM.DOM.decl('main-menu', {
    /* eslint-disable max-statements */
    onSetMod: {
        js: function () {
            this._initial();
        }
    },

    _autoOpenWidth: 1240,
    _destructTimeout: 400,

    _initial: function () {
        var chain = this.params.breadcrumbsChain;
        var isMenuOpened = this.params.menu.openMenu;
        var menuItem = this._getItemByChain(chain);
        var hasItems = menuItem.items && menuItem.items.length;

        this._updateParents(this.params.menu);

        // Нужно что бы на странице открывалось предыдущее меню
        // В случае, если не нужно отображать страницу с открытым меню
        this.breadcrumbsChain = hasItems || isMenuOpened ? chain : chain.slice(0, chain.length - 1);
        this._viewportWidth = BEM.DOM.win.innerWidth();
        this._isOpenSidebar = false;
        this._prevWinPos = 0;

        this._breadcrumbsStack = [];

        this.openedMenuItem = this._getItemByChain(this.breadcrumbsChain);

        this.bindTo(this.elem('switch'), 'pointerclick', this._handleSwitch.bind(this));
        this.bindTo(this.domElem, 'pointerclick', this._handleBreadcrumbsClick.bind(this));

        var bPage = this.findBlockOutside('b-page');

        this._sidebar = bPage.findBlockInside('sidebar');
        this._headBlock = this.findBlockInside('head');

        this.__self.maxHeadMargin = -this._headBlock.domElem.height();

        this.on('breadcrumbs-back', this._handleBreadcrumbsBack.bind(this));
        this.on('breadcrumbs-push', this._handleBreadcrumbsPush.bind(this));
        this.on('head-press', this._pressHead.bind(this));
        this.on('head-down-press', this._pressDownHead.bind(this));

        this._sidebar.on('close', this._handleCloseSidebar.bind(this));
        this._sidebar.on('open', this._handleOpenSidebar.bind(this));

        this.bindToWin('scroll', this._updateHead.bind(this));
        this.bindToWin('resize', $.debounce(this._onResize.bind(this), 300));

        this.afterCurrentEvent(function () {
            this._openMenu(isMenuOpened);
        }.bind(this));
    },

    _handleCloseSidebar: function () {
        this._isOpenSidebar = false;
        this.delMod('sidebar');
    },

    _handleOpenSidebar: function () {
        this._isOpenSidebar = true;
        this.setMod('sidebar', 'opened');
    },

    _handleSwitch: function () {
        if (this._isOpenSidebar) {
            this._sidebar.trigger('close');
        } else {
            this._sidebar.trigger('open', this.openedMenuItem);
        }
    },

    _handleBreadcrumbsBack: function () {
        this.breadcrumbsChain.splice(this.breadcrumbsChain.length - 1);
        this.openedMenuItem = this.openedMenuItem.parent || this.openedMenuItem;

        if (this._breadcrumbsStack.length > 0) {
            this._breadcrumbsStack.pop();
        }

        this._updateBreadcrumbs(this.breadcrumbsChain);
    },

    _handleBreadcrumbsPush: function (e, index) {
        this.breadcrumbsChain.push(index);
        this.openedMenuItem = this.openedMenuItem.items[index];
        this._breadcrumbsStack.push(index);
        this._updateBreadcrumbs(this.breadcrumbsChain);
    },

    /* eslint-disable complexity */
    _handleBreadcrumbsClick: function (e) {
        var $target = $(e.target);

        if (!$target.is(this.findElem('breadcrumbs-item'))) {
            return;
        }

        var chain = $target.attr('data-chain');
        var url = $target.data('url');
        var indexs = chain ? chain.split('.') : [];
        var targetMenuItem = this._getItemByChain(indexs);

        if (url) {
            window.location.assign(url);

            return;
        }

        if (targetMenuItem.url) {
            window.location.assign(targetMenuItem.url);

            return;
        }

        if (!this._isOpenSidebar || !this._areEqualArrays(this.breadcrumbsChain, indexs)) {
            this.breadcrumbsChain = indexs;

            this._sidebar.trigger('open', targetMenuItem);
        }
    },

    /**
     * Проверяет два массива на равенство
     * @param {Array} thisArray
     * @param {Array} thatArray
     * @returns {Boolean}
     * @private
     */
    _areEqualArrays: function (thisArray, thatArray) {
        if (thisArray.length !== thatArray.length) {
            return false;
        }

        for (var idx = 0; idx < thisArray.length; idx += 1) {
            if (thisArray[idx] !== thatArray[idx]) {
                return false;
            }
        }

        return true;
    },

    _updateBreadcrumbs: function (chain) {
        BEM.DOM.replace(this.findElem('breadcrumbs'), BH.apply({
            block: 'main-menu',
            elem: 'breadcrumbs',
            chain: chain,
            menu: this.params.menu,
            shouldAddBreadcrumbs: this._breadcrumbsStack.length === 0
        }));
    },

    _getItemByChain: function (indexs) {
        var result = this.params.menu;

        for (var i = 0; i < indexs.length; i += 1) {
            result = result.items[indexs[i]];
        }

        return result;
    },

    _updateParents: function (menuItem) {
        if (!menuItem || !menuItem.items || !menuItem.items.length) {
            return;
        }

        for (var i = 0; i < menuItem.items.length; i += 1) {
            var childItem = menuItem.items[i];

            childItem.parent = menuItem;
            this._updateParents(childItem);
        }
    },

    _pressHead: function () {
        this._headBlock.setMod('hidden', 'yes');

        this._isPressed = true;
    },

    _pressDownHead: function () {
        this._headBlock.delMod('hidden');

        this._isPressed = false;
    },

    /**
     * Меню открывается только на широких экранах и если присутствует get-параметр
     * принудительного открытия
     * На мобильных не открывается в любом случае
     * @param {Boolean} isMenuOpened
     * @private
     */
    _openMenu: function (isMenuOpened) {
        if (this._viewportWidth >= this._autoOpenWidth) {
            this._sidebar.trigger('open', this.openedMenuItem);
        } else if (!BH.lib.global.isMobile && isMenuOpened) {
            this._sidebar.trigger('open', this._getItemByChain(this.breadcrumbsChain));
        }
    },

    /**
     * При ресайзе окна открываем меню только в случае увеличения
     * @private
     */
    _onResize: function () {
        var currentWidth = BEM.DOM.win.innerWidth();

        if (
            !this._isOpenSidebar &&
            this._viewportWidth < this._autoOpenWidth &&
            currentWidth >= this._autoOpenWidth
        ) {
            this._viewportWidth = currentWidth;
            this._openMenu(false);
        }
    },

    _updateHead: function () { /* Переопределено для платформы desktop */ }
}, {

    /**
     * Приводит верхний отступ шапки в рамки допустимых значений
     * @param {Number} margin
     * @returns {Number}
     * @private
     */
    normalizeMargin: function (margin) {
        if (margin > 0) {
            return 0;
        }

        if (margin < this.maxHeadMargin) {
            return this.maxHeadMargin;
        }

        return margin;
    }
});
