module.exports = function (bh) {
    bh.match('materials', function (ctx, json) {
        var materials = json.materials;

        ctx
            .js(true)
            .content([
                materials.title && {
                    elem: 'title',
                    tag: 'h1',
                    mix: { block: 'content', elem: 'title' },
                    content: materials.title
                },
                materials.sections.map(function (section) {
                    return {
                        elem: 'section',
                        section: section
                    };
                })
            ]);
    });

    bh.match('materials__section', function (ctx, json) {
        ctx
            .tag('section')
            .content([
                {
                    elem: 'anchor',
                    attrs: { id: json.section.anchor }
                },
                {
                    elem: 'subtitle',
                    tag: 'h2',
                    content: json.section.title
                },
                json.section.groups.map(function (group) {
                    return {
                        elem: 'group',
                        group: group
                    };
                })
            ]);
    });

    bh.match('materials__group', function (ctx, json) {
        if (!json.group.items.length) {
            return '';
        }

        ctx.content([
            {
                elem: 'group-label',
                content: json.group.title
            },
            {
                elem: 'group-list',
                items: json.group.items
            }
        ]);
    });

    bh.match('materials__group-list', function (ctx, json) {
        ctx.content(json.items.map(function (item) {
            return {
                elem: 'item',
                item: item
            };
        }));
    });

    bh.match('materials__item', function (ctx, json) {
        var text = json.item.text;

        ctx.content([
            {
                elem: 'item-title',
                title: json.item.title,
                opened: json.item.opened,
                text: text
            },
            text && {
                elem: 'item-text',
                mix: {
                    block: 'html-content'
                },
                mods: {
                    hidden: !json.item.opened && 'yes'
                },
                content: text
            }
        ]);
    });

    bh.match('materials__item-title', function (ctx, json) {
        var hasText = Boolean(json.text);

        ctx
            .tag('h3')
            .mods({
                clickable: hasText && !json.opened
            })
            .content([
                hasText && !json.opened && {
                    block: 'icon',
                    mods: {
                        type: 'accordion-arrow'
                    }
                },
                json.title
            ]);
    });
};
