module.exports = function (bh) {
    'use strict';

    bh.match('metrika', function (ctx) {
        var counters = ctx.param('metrikaCounters');

        if (!(Array.isArray(counters) && counters.length)) {
            return '';
        }

        var content = counters.map(function (counter) {
            return {
                block: 'b-statcounter',
                content: {
                    elem: 'metrika',
                    elemMods: { type: 'js' },
                    counter: counter.id,
                    js: counter.params
                }
            };
        });

        ctx
            .js({
                counter: counters[0].id
            })
            .tag('section')
            .content(content);
    });
};
