/* global BEM, BH, window, $ */
BEM.DOM.decl('metrika', {
    onSetMod: {
        js: {
            inited: function () {
                'use strict';
                this._attempts = 100; // Количество ретраев для отправки события в Метрику
                this._errorStorage = {}; // Индекс ошибок

                window.onerror = this._dumpErrorOnce.bind(this); // Отлавливаем браузерную ошибку

                this._discoverMetrika();
            }
        }
    },

    _discoverMetrika: function () {
        'use strict';
        this.__self._metrika = window['yaCounter' + this.params.counter];
        --this._attempts;

        if (!this.__self._metrika) {
            if (this._attempts > 0) {
                setTimeout(this._discoverMetrika.bind(this), 1000);
            }
        } else if (this.__self._pendingGoals && this.__self._pendingGoals.length) {
            this._reachPendingGoals();
        }
    },

    _reachPendingGoals: function () {
        'use strict';
        do {
            this.__self.reachGoal(this.__self._pendingGoals.pop());
        } while (this.__self._pendingGoals.length);
    },

    /**
     * Сдампить ошибку и закэшировать
     *
     * Параметры приходят в стандартной браузерной ошибке
     * @param {String} message
     * @param {String} file
     * @param {Number} line
     * @param {Number} [column]
     * @param {Error|String} [error]
     */
    _dumpErrorOnce: function (message, file, line, column, error) {
        'use strict';
        var key = [message, file, line, column].join();
        if (key in this._errorStorage) {
            return;
        }
        this._dumpGlobalError(message, file, line, column, error);
        this._errorStorage[key] = true;
    },

    /**
     * Отправляет отчет об ошибке
     * @param {String} message
     * @param {String} file
     * @param {Number} line
     * @param {Number} [column]
     * @param {Error|String} [error]
     */
    _dumpGlobalError: $.debounce(function (message, fileName, line, column) {
        'use strict';
        line = Number(line);

        if (isNaN(line)) {
            return;
        }

        var global = BH.lib.global || {};
        var host = location.hostname; // Хост для фильтрации разработческих машин
        var file = fileName || 'unknown'; // Название файла, в котором возникла ошибка
        var text = line + ':' + (column || 0) + ' ' + message; // Сообщение ошибки
        var href = window.location.href;
        var userAgent = window.navigator && window.navigator.userAgent;
        var data = 'uid=' + (global.uid || '') +
            ';login=' + (global.login || '') +
            ';yandexuid=' + (global.yandexuid || '') +
            ';isMobile=' + global.isMobile +
            ';lang=' + global.lang +
            ';browser=' + global.browser +
            ';navigator=' + userAgent;
        var log = {};

        log[host] = {};
        log[host][file] = {};
        log[host][file][text] = {};
        log[host][file][text][href] = data;

        this.__self.reachGoal({
            target: 'client_error',
            params: {
                error: log
            }
        });
    }, 1000)
}, {
    /**
     * Достижение цели Метрики. Аргумент должен иметь вид { target: 'XXX', params: { a: 'b' } }
     * @param {Object} goal
     */
    reachGoal: function (goal) {
        'use strict';
        if (this._metrika) {
            // Описание метода `reachGoal`: https://yandex.ru/support/metrika/objects/reachgoal.xml
            this._metrika.reachGoal(goal.target, goal.params);
        } else {
            this._pendingGoals = this._pendingGoals || [];
            this._pendingGoals.push(goal);
        }
    }
});
