module.exports = function (bh) {
    'use strict';
    bh.match('my-certificates', function (ctx, json) {
        var data = json.data;
        var certificates = data.certificates;
        var publicPageUrl = json.data.publicPageUrl;
        var noCerts = json.data.noCerts ? '_no_certs' : '';
        var descriptionKey = `my-certificates.description${noCerts}`;

        ctx.content([
            {
                elem: 'title',
                mix: { block: 'content', elem: 'title' },
                content: bh.lib.i18n('common', 'my-certificates.title')
            },
            {
                elem: 'text',
                mix: { block: 'html-content' },
                content: bh.lib.i18n('common', descriptionKey, { url: publicPageUrl })
            },
            data.pendingTrials.length > 0 && {
                elem: 'pending-trials',
                pendingTrials: data.pendingTrials
            },
            certificates.cert.active.map(function (cert) {
                return {
                    block: 'cert',
                    data: {
                        cert: cert,
                        collapsible: true,
                        start: true,
                        share: true,
                        hideShare: true,
                        data: data,
                        publicPageUrl: publicPageUrl
                    }
                };
            }),
            data.nullifiedCerts.length > 0 && {
                elem: 'nullified-certs',
                nullifiedCerts: data.nullifiedCerts
            },
            data.failedTrials.length > 0 && {
                elem: 'proposals',
                failedTrials: data.failedTrials
            },
            certificates.cert.inactive.length > 0 && {
                block: 'cert-archive',
                certificates: certificates.cert.inactive
            },
            certificates.achievement.length > 0 && {
                block: 'achievements',
                achievements: certificates.achievement,
                share: true
            }
        ]);
    });

    bh.match('my-certificates__proposals', function (ctx, json) {
        ctx.content(json.failedTrials.map(function (proposal) {
            return {
                block: 'proposal',
                proposal: proposal
            };
        }));
    });

    bh.match('my-certificates__pending-trials', function (ctx, json) {
        ctx.content(json.pendingTrials.map(function (trial) {
            return {
                block: 'pending-trial',
                trial: trial
            };
        }));
    });

    bh.match('my-certificates__nullified-certs', function (ctx, json) {
        ctx.content(json.nullifiedCerts.map(function (cert) {
            return {
                block: 'cert-nullified',
                cert: cert
            };
        }));
    });
};
