module.exports = function (bh) {
    'use strict';
    bh.match('page-title', function (ctx, json) {
        var title = bh.lib.i18n('common', json.title) || json.title;
        var text = bh.lib.util.template(bh.lib.i18n('common', json.text));
        var form = json.form;
        var attemptId = form && form.attemptId;
        var formId = form && form.formId;

        ctx
            .js(formId || false)
            .content([
                title && {
                    elem: 'title',
                    content: title
                },
                json.subtitle && {
                    elem: 'subtitle',
                    content: bh.lib.util.template(bh.lib.i18n('common', json.subtitle)),
                    mix: { block: 'html-content' }
                },
                json.text && {
                    elem: 'text',
                    content: text
                },
                json.form && {
                    block: 'modal',
                    mix: { block: 'proctoring-footer', elem: 'modal' },
                    mods: {
                        theme: 'normal',
                        autoclosable: 'yes'
                    },
                    content: {
                        block: 'iframe-form',
                        formId: formId,
                        params: attemptId && [
                            { key: 'trial_id', value: attemptId }
                        ]
                    }
                }
            ]);
    });

    bh.match('page-title__title', function (ctx) {
        ctx.tag('h1');
    });

    bh.match('page-title__subtitle', function (ctx) {
        ctx.tag('h2');
    });
};
