module.exports = function (bh) {
    'use strict';
    bh.match('pending-trial', function (ctx, json) {
        ctx.content([
            {
                elem: 'date',
                content: bh.lib.util.date.humanizeDate(json.trial.started)
            },
            {
                elem: 'title',
                tag: 'h3',
                content: bh.lib.i18n('common', 'my-certificates.pending-trial.title', {
                    exam: bh.lib.i18n('cert', json.trial.examSlug)
                })
            },
            {
                elem: 'text',
                content: bh.lib.i18n('common', 'my-certificates.pending-trial.text')
            }
        ]);
    });
};
