module.exports = function (bh) {
    bh.match('proposal', function (ctx, json) {
        var proposal = json.proposal;

        var hasMaterials = proposal.materials.sections.length > 0;
        var resultButtonType = hasMaterials ? 'materials' : 'result';

        ctx.content([
            {
                elem: 'date',
                content: bh.lib.util.date.humanizeDate(proposal.started)
            },
            {
                elem: 'title',
                content: bh.lib.i18n('common', 'my-certificates.failed.title', {
                    exam: bh.lib.i18n('common', 'my-certificates.failed.exam.' + proposal.examSlug)
                })
            },
            proposal.state === 'disabled' && proposal.availabilityDate && {
                elem: 'text',
                content: bh.lib.i18n('common', 'my-certificates.failed.trial', {
                    date: bh.lib.util.date.humanizeDate(proposal.availabilityDate)
                })
            },
            {
                elem: 'buttons',
                content: [
                    {
                        block: 'button2',
                        mods: {
                            theme: 'action',
                            type: 'link',
                            size: 'm'
                        },
                        url: proposal.resultUrl,
                        text: bh.lib.i18n('common', 'my-certificates.failed.' + resultButtonType)
                    },
                    proposal.state === 'enabled' && {
                        block: 'button2',
                        mods: {
                            theme: 'normal',
                            type: 'link',
                            size: 'm'
                        },
                        url: proposal.examUrl,
                        text: bh.lib.i18n('common', 'my-certificates.failed.start')
                    }
                ]
            }
        ]);
    });
};
