BEM.DOM.decl({ block: 'question', modName: 'proctoring', modVal: 'yes' }, {
    onSetMod: {
        js: function () {
            this.__base.apply(this);

            this._initProctoring();
        }
    },

    _initProctoring: function () {
        this._proctoringStarted = false;
        this._cameraStream = null;

        this._cacheProctoringElems();

        this._initProctoringSettings();
        this._showProctoringSpinner();

        // Should happen after proctoring-footer init
        setTimeout(this._restoreMetricsInfo.bind(this), 0);

        this
            .bindTo('supervisor-iframe-ready', this._requestMediaDevices)
            .bindTo('supervisor-metrics', this._onSupervisorMetrics);

        this._fixCheckButton.on('click', this._onFixCheckButtonClick, this);
        this._continueButton.on('click', this._onContinueButtonClick, this);

        setTimeout(this._iframeInitError.bind(this), 30000); // 30 секунд
    },

    _cacheProctoringElems: function () {
        this._bPage = this.findBlockOutside('b-page');
        this._notificator = BEM.blocks['proctoring-footer'];

        this._proctoringSpinner = this.findElem('proctoring-spinner');
        this._proctoringSpin2 = this.findBlockInside(this._proctoringSpinner, 'spin2');
        this._questionContent = this.findElem('content');

        this._finishModal = this.findBlockInside({ blockName: 'modal', modName: 'type', modVal: 'finish' });
        this._fixSuccessModal = this.findBlockInside({ blockName: 'modal', modName: 'type', modVal: 'fix-success' });
        this._waitModal = this.findBlockInside({ blockName: 'modal', modName: 'type', modVal: 'wait' });

        this._waitModalElem = this.findElem('wait-modal');

        this._fixCheckButton = this._waitModal.findBlockInside('button2');
        this._continueButton = this._fixSuccessModal.findBlockInside('button2');
    },

    _initProctoringSettings: function () {
        var proctoringSettings = this.params.proctoringSettings;

        this._metricsInfo = proctoringSettings.metricSettings.map(function (setting) {
            setting.criticalDuration = setting.criticalDuration * 60 * 1000;

            return setting;
        });

        this._waitData = {
            startTime: null,
            metric: null,
            criticalDuration: proctoringSettings.waitForFinish * 60 * 1000,
            maxFixChecksCount: proctoringSettings.fixChecksCount
        };
    },

    _restoreMetricsInfo: function () {
        for (var i = 0; i < this._metricsInfo.length; i += 1) {
            var metricInfo = this._metricsInfo[i];
            var criticalMetric = this._findCriticalMetirc(metricInfo.metric);

            if (!criticalMetric) {
                continue;
            }

            metricInfo.startViolation = Date.now() - criticalMetric.duration;

            this._checkHighMetric(metricInfo);

            if (this._isInViolationMode()) {
                break;
            }
        }
    },

    _findCriticalMetirc: function (metric) {
        var proctoringMetrics = this.params.proctoringMetrics || {};
        var criticalMetrics = proctoringMetrics.critical || [];

        return criticalMetrics.filter(function (criticalMetric) {
            return criticalMetric.metric === metric;
        })[0];
    },

    _onSupervisorMetrics: function (e, data) {
        this._checkMetrics(data);
        this._saveCriticalMetrics();

        if (this._notificator) {
            this._notificator.notify(data);
        }
    },

    _checkMetrics: function (metrics) {
        if (this._isInViolationMode()) {
            this._processViolation(metrics[this._waitData.metric]);

            return;
        }

        for (var i = 0; i < this._metricsInfo.length; i += 1) {
            var metricInfo = this._metricsInfo[i];

            var value = metrics[metricInfo.metric];

            if (value >= metricInfo.criticalValue) {
                this._processHighMetric(metricInfo);
            } else {
                metricInfo.startViolation = null;
            }

            if (this._isInViolationMode()) {
                break;
            }
        }
    },

    _saveCriticalMetrics: function () {
        var criticalMetrics = this._buildCriticalMetrics();

        $.ajax({
            type: 'POST',
            url: this.params.proctoringMetricsUrl,
            headers: {
                'x-csrf-token': this._sk,
                'Content-Type': 'application/json'
            },
            contentType: 'application/json',
            data: JSON.stringify({ critical: criticalMetrics })
        });
    },

    _buildCriticalMetrics: function () {
        var now = Date.now();

        return this._metricsInfo
            .filter(function (metricInfo) {
                return metricInfo.startViolation;
            })
            .map(function (metricInfo) {
                return {
                    metric: metricInfo.metric,
                    duration: now - metricInfo.startViolation
                };
            });
    },

    _processViolation: function (currentValue) {
        if (this._isViolationResolved()) {
            return;
        }

        var metricInfo = this._findMetricInfo(this._waitData.metric);

        if (currentValue >= metricInfo.criticalValue) {
            this._onFixFail();

            return;
        }

        this._onFixSuccess();
    },

    _findMetricInfo: function (metric) {
        return this._metricsInfo.filter(function (metricObj) {
            return metricObj.metric === metric;
        })[0];
    },

    _processHighMetric: function (metricInfo) {
        var now = Date.now();

        if (!metricInfo.startViolation) {
            metricInfo.startViolation = now;

            return;
        }

        this._checkHighMetric(metricInfo);
    },

    _checkHighMetric: function (metricInfo) {
        var now = Date.now();

        var violationDuration = now - metricInfo.startViolation;

        if (violationDuration >= metricInfo.criticalDuration) {
            this._setViolationMode(now, metricInfo.metric);
        }
    },

    _isInViolationMode: function () {
        return Boolean(this._waitData.metric);
    },

    _isViolationResolved: function () {
        return (
            this._fixSuccessModal.hasMod('visible', 'yes') ||
            this._finishModal.hasMod('visible', 'yes')
        );
    },

    _setViolationMode: function (startTime, metric) {
        this._disableControls();

        this._waitData.startTime = startTime;
        this._waitData.metric = metric;
        this._waitData.fixChecksCount = 0;

        this._renderWaitModalText(metric);

        this._notificator.disableNotifications();
        this._bPage.setMod('hide-scroll', 'yes');
        this._waitModal.setMod('visible', 'yes');
        this.delMod(this._waitModalElem, 'fix');

        BH.lib.util.logger.info({
            place: 'Show wait modal',
            metric: metric,
            openId: this._openId,
            attemptId: this._attemptId
        });
    },

    _unsetViolationMode: function (metric) {
        this._waitData.metric = null;
        this._waitData.startTime = null;

        this._bPage.delMod('hide-scroll');
        this._notificator.enableNotifications();
        this._enableControls();

        this._metricsInfo.forEach(function (info) {
            info.startViolation = null;
        });

        BH.lib.util.logger.info({
            place: 'Hide wait modal',
            metric: metric,
            openId: this._openId,
            attemptId: this._attemptId
        });
    },

    _renderWaitModalText: function (metric) {
        var metricInfo = this._findMetricInfo(metric);

        this._renderModalText('wait', metricInfo.waitModal);
    },

    _renderModalText: function (modal, modalSettings) {
        var modalTitle = this.findElem(modal + '-modal', 'modal-title');
        var modalContent = this.findElem(modal + '-modal', 'modal-content');

        BEM.DOM.update(modalTitle, modalSettings.title);
        BEM.DOM.update(modalContent, modalSettings.content);
    },

    _onFixCheckButtonClick: function () {
        this.setMod(this._waitModalElem, 'fix', 'checking');
    },

    _isCheckingFix: function () {
        return this.hasMod(this._waitModalElem, 'fix', 'checking');
    },

    _onFixSuccess: function () {
        this._resolveFix('success', this._showFixSuccessModal.bind(this));
    },

    _showFixSuccessModal: function () {
        var hideDelay = this.params.proctoringSettings.fixSuccessModal.hideDelay;

        this._waitModal.setMod('visible', 'no');
        this._fixSuccessModal.setMod('visible', 'yes');

        setTimeout(function () {
            this._onContinueButtonClick();
        }.bind(this), hideDelay * 1000);
    },

    _onContinueButtonClick: function () {
        this._fixSuccessModal.setMod('visible', 'no');
        this._unsetViolationMode();
    },

    _onFixFail: function () {
        var metricInfo = this._findMetricInfo(this._waitData.metric);
        var isTimeUp = Date.now() - this._waitData.startTime >= this._waitData.criticalDuration;

        if (isTimeUp) {
            this._resolveFix('fail', this._finishAttemptByViolation.bind(this, metricInfo));

            return;
        }

        if (this._isCheckingFix()) {
            this._waitData.fixChecksCount += 1;

            var isChecksCountUp = this._waitData.fixChecksCount >= this._waitData.maxFixChecksCount;

            if (isChecksCountUp) {
                this._resolveFix('fail', this._finishAttemptByViolation.bind(this, metricInfo));

                return;
            }

            this._resolveFix('fail', function () {
                this.delMod(this._waitModalElem, 'fix');
            }.bind(this));
        }
    },

    _resolveFix: function (type, callback) {
        var helper = BEM.blocks['animation-events'];

        var onResolveAnimationEnd = function () {
            helper.offAnimation(this._waitModalElem, 'End', onResolveAnimationEnd);

            callback();
        }.bind(this);

        var onCheckingAnimationIteration = function () {
            helper.offAnimation(this._waitModalElem, 'Iteration', onCheckingAnimationIteration);

            this.setMod(this._waitModalElem, 'fix', type);

            helper.onAnimation(this._waitModalElem, 'End', onResolveAnimationEnd);
        }.bind(this);

        if (this._isCheckingFix()) {
            helper.onAnimation(this._waitModalElem, 'Iteration', onCheckingAnimationIteration);
        } else {
            onCheckingAnimationIteration();
        }
    },

    _finishAttemptByViolation: function (metricInfo) {
        var nullifySettings = metricInfo.nullify;

        var startViolation = metricInfo.startViolation;
        var trialStartedTime = new Date(this.params.trialStartedTime).valueOf();

        // Convert to ms from minutes
        var maxTimeFromStart = nullifySettings.maxTimeFromStart * 60 * 1000;

        var isAtTrialStart = startViolation - trialStartedTime < maxTimeFromStart;
        var requestNullify = nullifySettings.requestNullify && isAtTrialStart;

        this.bindTo('supervisor-stopped', this._finishAttempt.bind(this, requestNullify));
        BEM.blocks.supervisor.stop();
    },

    _finishAttempt: function (requestNullify) {
        var data = {
            isCritMetrics: true,
            requestNullify: requestNullify
        };

        $.ajax({
            type: 'POST',
            url: this.params.finishUrl,
            headers: {
                'x-csrf-token': this._sk,
                'Content-Type': 'application/json'
            },
            contentType: 'application/json',
            data: JSON.stringify(data)
        })
            .done(this._handleFinishSuccess.bind(this))
            .fail(this._handleFinishError.bind(this));
    },

    _handleFinishError: function (err) {
        var internalCode = err && err.responseJSON && err.responseJSON.internalCode;

        BH.lib.util.logger.info({
            error: err,
            place: 'Failed to finish attempt',
            openId: this._openId,
            attemptId: this._attemptId,
            internalCode: internalCode
        });
    },

    _handleFinishSuccess: function (response) {
        BH.lib.util.logger.info({
            place: 'Finish attempt by crit metrics',
            openId: this._openId,
            attemptId: this._attemptId
        });

        var modalType = response.isNullified ? 'nullifiedFinishModal' : 'finishModal';

        this._renderModalText('finish', this.params.proctoringSettings[modalType]);

        this._waitModal.setMod('visible', 'no');
        this._finishModal.setMod('visible', 'yes');
        this._attemptTime.stopServerTime();
        this._bPage.setMod('hide-scroll', 'yes');

        this._notificator.hideCameraStream();
        this._cameraStream.getTracks().forEach(function (track) {
            track.stop();
        });
    },

    _requestMediaDevices: function () {
        this.bindTo('getmedia-success', this._requestCameraAccess.bind(this));
        this.bindTo('getmedia-error', this._mediaError.bind(this));

        BEM.blocks.supervisor.getmedia();
    },

    _requestCameraAccess: function () {
        navigator.mediaDevices.getUserMedia({ video: true })
            .then(function (stream) {
                this._createSupervisor();
                this._cameraStream = stream;
            }.bind(this))
            .catch(function (err) {
                BH.lib.util.logger.info({
                    error: err.name + ': ' + err.message,
                    place: 'Request camera access failed',
                    openId: this._openId,
                    attemptId: this._attemptId
                });
                this._createSupervisor(); // TODO request user to approve access
            }.bind(this));
    },

    _createSupervisor: function () {
        this.bindTo('supervisor-ready', this._initSupervisor.bind(this));

        BEM.blocks.supervisor.create();
    },

    _initSupervisor: function () {
        this.bindTo('supervisor-inited', this._startSupervisor.bind(this));
        this.bindTo('supervisor-init-error', this._onSupervisorInitError.bind(this));

        BEM.blocks.supervisor.init(this.params.userProctoringToken);
    },

    _onSupervisorInitError: function (e, error) {
        BH.lib.util.logger.info({
            error: error,
            place: 'Supervisor init error',
            openId: this._openId,
            attemptId: this._attemptId
        });
    },

    _iframeInitError: function () {
        if (this._proctoringStarted) {
            return;
        }

        BH.lib.util.logger.info({
            place: 'Iframe init error',
            openId: this._openId,
            attemptId: this._attemptId
        });

        this._showProctoringFailError();
    },

    _showProctoringFailError: function () {
        this.setMod(this._proctoringSpinner, 'disabled', 'yes');
        this._proctoringSpin2.delMod('progress');
        this._notificator.setProctoringError();
    },

    _mediaError: function (e, error) {
        BH.lib.util.logger.info({
            error: error,
            place: 'Proctoring get media error',
            openId: this._openId,
            attemptId: this._attemptId
        });
    },

    _startSupervisor: function () {
        this.bindTo('supervisor-start-error', function (e, error) {
            BH.lib.util.logger.info({
                error: error,
                place: 'Supervisor start error',
                openId: this._openId,
                attemptId: this._attemptId
            });

            this._showProctoringFailError();
        }.bind(this));

        this.bindTo('supervisor-started', function () {
            this._proctoringStarted = true;

            this._notificator.setProctoringStarted();
            this._hideProctoringSpinner();

            window.addEventListener('resize', function () {
                BEM.blocks.supervisor.resize();
            });
        });

        BEM.blocks.supervisor.start();
    },

    /**
     * Скрывает спиннер после инициализации прокторинга
     * @private
     */
    _hideProctoringSpinner: function () {
        this.setMod(this._proctoringSpinner, 'disabled', 'yes');
        this.delMod(this._questionContent, 'hidden');
        this._proctoringSpin2.delMod('progress');
    },

    /**
     * Показывает спиннер во время инициализации прокторинга
     * @private
     */
    _showProctoringSpinner: function () {
        this._proctoringSpin2.setMod('progress', 'yes');
        this.setMod(this._questionContent, 'hidden', 'yes');
        this.delMod(this._proctoringSpinner, 'disabled');
    }
});
