module.exports = function (bh) {
    'use strict';
    bh.match('question', function (ctx, json) {
        var question = json.question;
        var isProctoring = question.exam.isProctoring;
        var proctoringInfo = question.proctoringFooter;

        ctx
            .mods({
                proctoring: isProctoring && 'yes'
            })
            .js({
                attemptId: question.attemptId,
                nextUrl: question.nextUrl,
                answerUrl: question.answerUrl,
                finishUrl: question.finishUrl,
                retlink: question.retlink,
                proctoringMetricsUrl: question.proctoringMetricsUrl,
                isProctoring: isProctoring,
                supervisorInitError: proctoringInfo && proctoringInfo.supervisorInitError,
                iframeInitError: proctoringInfo && proctoringInfo.iframeInitError,
                openId: json.openId,
                userProctoringToken: json.userProctoringToken,
                proctoringMetrics: question.proctoringMetrics,
                proctoringSettings: question.proctoringSettings,
                trialStartedTime: question.trial.started
            })
            .content([
                {
                    elem: 'content-wrapper',
                    content: [
                        {
                            elem: 'content',
                            mods: isProctoring ? { hidden: 'yes' } : {},
                            content: [
                                {
                                    block: 'secret-key-input'
                                },
                                {
                                    elem: 'data',
                                    question: json.question
                                },
                                {
                                    elem: 'buttons'
                                }
                            ]
                        },
                        isProctoring && {
                            elem: 'proctoring-spinner',
                            content: {
                                block: 'spin2',
                                mods: {
                                    size: 'l',
                                    progress: 'yes'
                                }
                            }
                        }
                    ]
                },
                {
                    elem: 'error-wrap',
                    content: {
                        elem: 'error'
                    }
                },
                isProctoring && [
                    {
                        block: 'supervisor',
                        proctoringIframeUrl: json.proctoringIframeUrl,
                        proctoringIframeHost: json.proctoringIframeHost
                    },
                    {
                        block: 'notifications-list'
                    },
                    {
                        elem: 'modals',
                        question: question
                    }
                ]
            ]);
    });

    bh.match('question__modals', function (ctx, json) {
        var question = json.question;

        ctx.content(
            [
                {
                    type: 'wait',
                    modal: {
                        hasAnimation: true
                    }
                },
                {
                    type: 'fix-success',
                    modal: question.proctoringSettings.fixSuccessModal
                },
                {
                    type: 'finish',
                    modal: {},
                    button: {
                        url: question.resultUrl
                    }
                }
            ].map(function (settings) {
                var type = settings.type;
                var buttonSettings = settings.button || {};

                var buttonKey = [
                    'attempt',
                    type,
                    'modal.button'
                ].join('.');

                return {
                    block: 'modal',
                    mods: {
                        theme: 'normal',
                        visible: 'no',
                        type: type
                    },
                    mix: {
                        block: 'question',
                        elem: type + '-modal'
                    },
                    content: [
                        settings.modal.hasAnimation && {
                            block: 'question',
                            elem: 'modal-circle-background'
                        },
                        {
                            block: 'question',
                            elem: 'modal-title',
                            mix: { block: 'html-content' },
                            content: settings.modal.title
                        },
                        {
                            block: 'question',
                            elem: 'modal-content',
                            mix: { block: 'html-content' },
                            content: settings.modal.content
                        },
                        {
                            block: 'question',
                            elem: 'modal-button',
                            content: {
                                block: 'button2',
                                mods: {
                                    theme: 'action',
                                    size: 'm',
                                    type: 'link'
                                },
                                text: bh.lib.i18n('common', buttonKey),
                                url: buttonSettings.url
                            }
                        }
                    ]
                };
            })
        );
    });

    bh.match('question__data', function (ctx, json) {
        ctx
            .tag('article')
            .content([
                {
                    elem: 'seq',
                    tag: 'input',
                    attrs: { type: 'hidden', value: json.question.seq }
                },
                {
                    elem: 'section',
                    tag: 'h4',
                    content: json.question.section.title
                },
                {
                    elem: 'text',
                    content: [
                        json.question.seq,
                        '. ',
                        bh.lib.util.template(json.question.text)
                    ]
                },
                {
                    elem: json.question.type === 'one_answer' ? 'answers-one' : 'answers-many',
                    answers: json.question.answers,
                    questionSeq: json.question.seq
                }
            ]);
    });

    bh.match('question__answers-many', function (ctx, json) {
        ctx.content({
            content: json.answers.map(function (answer) {
                return {
                    elem: 'answer',
                    mix: {
                        block: 'question',
                        elem: 'answer'
                    },
                    content: {
                        block: 'checkbox',
                        mods: { size: 'm' },
                        checkboxAttrs: { value: answer.id, name: json.questionSeq },
                        content: { elem: 'label', content: answer.text }
                    }
                };
            })
        });
    });

    bh.match('question__answers-one', function (ctx, json) {
        ctx.content({
            block: 'radiobox',
            mods: { size: 'm' },
            content: json.answers.map(function (answer) {
                return {
                    elem: 'answer',
                    mix: {
                        block: 'question',
                        elem: 'answer'
                    },
                    content: {
                        elem: 'radio',
                        content: answer.text,
                        controlAttrs: { value: answer.id }
                    }
                };
            })
        });
    });
};
