/* global BEM, BH, $ */
BEM.DOM.decl('question', {
    onSetMod: {
        js: function () {
            this._MOBILE_HEAD = 48;
            this._FINISH_ATTEMPT_TIMEOUT = 3000;

            this._answerButton = this.findBlockInside({ blockName: 'button2', modName: 'theme', modVal: 'action' });
            this._skipButton = this.findBlockInside({ blockName: 'button2', modName: 'theme', modVal: 'pseudo' });
            this._radiobox = this.findBlockInside('radiobox');
            this._sk = this.findBlockInside('secret-key-input').domElem.val();
            this._error = this.findElem('error');
            this._attemptTime = this.findBlockOutside('b-page').findBlockInside('attempt-time');

            this._attemptId = parseInt(this.params.attemptId, 10);
            this._openId = this.params.openId;

            this._bindEvents();
            this._initPopup();
        }
    },

    _bindEvents: function () {
        this._answerButton.on('click', this._onAnswerClick.bind(this));
        this._skipButton.on('click', this._sendAnswer.bind(this, false, null));

        // Используем делегирование, потому что контент блока будет заменяться при переходе между вопросами
        BEM.blocks.radiobox.on(this.domElem, 'change', this._onRadioboxChange.bind(this));
        BEM.blocks.checkbox.on(this.domElem, 'change', this._onCheckboxChange.bind(this));
    },

    _onAnswerClick: function () {
        var answers = this._radiobox ? [this._radiobox.val()] : this.findBlocksInside('checkbox')
            .filter(function (checkbox) {
                return checkbox.isChecked();
            })
            .map(function (checkbox) {
                return checkbox.val();
            });

        this._sendAnswer(false, answers);
    },

    /**
     * Отправление ответа на текущий вопрос
     * @param {Boolean} isSessionStopped
     * @param {*} answers
     * @private
     */
    _sendAnswer: function (isSessionStopped, answers) {
        this._disableControls();
        this.delMod(this._error, 'visible');

        var params = {
            attemptId: parseInt(this.params.attemptId, 10),
            seq: parseInt(this.findElem('seq').val(), 10)
        };

        if (answers && answers.length) {
            params.answerId = answers.map(function (answer) {
                return parseInt(answer, 10);
            });
        }

        $.ajax({
            type: 'POST',
            url: this.params.answerUrl + this._getSessionStoppedParam(isSessionStopped),
            headers: {
                'x-csrf-token': this._sk
            },
            contentType: 'application/json',
            data: JSON.stringify(params)
        })
            .done(this._onResponse.bind(this, this._getNextQuestion.bind(this, false), this._sendAnswer))
            .fail(this._handleAnswerError.bind(this));
    },

    _handleAnswerError: function (err) {
        var internalCode = err && err.responseJSON && err.responseJSON.internalCode;

        if (internalCode === '403_QAA') {
            return this._getNextQuestion();
        }

        BH.lib.util.logger.info({
            error: err,
            place: 'Failed to answer question',
            openId: this._openId,
            attemptId: this._attemptId
        });

        return this._showError('question.answer', err);
    },

    /**
     * Получение следующего вопроса после успешного ответа или пропуска
     * @param {Boolean} isSessionStopped
     * @private
     */
    _getNextQuestion: function (isSessionStopped) {
        var retlinkParam = this.params.retlink ? '&retlink=' + encodeURIComponent(this.params.retlink) : '';

        $.ajax({
            cache: false,
            url: this.params.nextUrl + this._getSessionStoppedParam(isSessionStopped) + retlinkParam,
            headers: {
                'Cache-control': 'no-cache',
                Pragma: 'no-cache',
                Expires: 0
            }
        })
            .done(this._onResponse.bind(this, this._renderQuestion, this._getNextQuestion))
            .fail(this._handleNextQuestionError.bind(this));
    },

    _handleNextQuestionError: function (err) {
        BH.lib.util.logger.info({
            error: err,
            place: 'Failed to get next question',
            openId: this._openId,
            attemptId: this._attemptId
        });

        return this._showError('question.fetch', err);
    },

    /**
     * Возвращает GET-параметр остановки сессии
     * @private
     */
    _getSessionStoppedParam: function (isSessionStopped) {
        var sessionStopped = isSessionStopped || !this.params.isProctoring;

        return '?sessionStopped=' + (sessionStopped ? '1' : '0');
    },

    /**
     * Обрабатывает ответ пользователя
     * В случае, если ответ содержит поле redirectUrl, происходит редирект на этот URL
     * Иначе происходит рендеринг ответа и вставка его в DOM
     * @param callback
     * @param sourceHandler
     * @param data
     * @param status
     * @param xhr
     * @private
     */
    _onResponse: function (callback, sourceHandler, data, status, xhr) {
        var serverTime = new Date(xhr.getResponseHeader('Date'));
        if (!isNaN(serverTime.getTime())) {
            this._attemptTime.syncServerTime(serverTime);
        }

        if (this.params.isProctoring && data.stopSession) {
            this.bindTo('supervisor-stopped', sourceHandler.bind(this, true));

            return BEM.blocks.supervisor.stop();
        }

        if (data.redirectUrl) {
            this._redirectToResult(data);
        } else {
            callback.call(this, data);
        }
    },

    _redirectToResult: function (data) {
        this._showSpinner();

        setTimeout(function () {
            window.location = data.redirectUrl;
        }, this._FINISH_ATTEMPT_TIMEOUT);
    },

    /**
     * Рендеринг вопроса и вставка его в DOM
     * @param data
     * @private
     */
    _renderQuestion: function (data) {
        var newQuestion = BH.apply({
            block: 'question',
            elem: 'data',
            question: data
        });

        BEM.DOM.replace(this.findElem('data'), newQuestion);
        this._radiobox = this.findBlockInside('radiobox');
        this._skipButton.delMod('disabled');
        this.domElem.trigger('progress-change', data);

        if (BH.lib.global.isMobile) {
            BEM.blocks['scroll-to'].scrollTo(this._MOBILE_HEAD);
        }
    },

    _showError: function (tankerKey, err) {
        var errorText = BEM.blocks['i-bem'].createErrorMessage(err, tankerKey);
        this._enableControls();
        this._error.text(errorText);
        this.setMod(this._error, 'visible', 'yes');
    },

    /**
     * При нажатиях на кнопки, пока сервер не ответил, блокируем контролы (radiobox, checkbox и button).
     * @private
     */
    _disableControls: function () {
        if (this._radiobox) {
            this._radiobox.setMod('disabled', 'yes');
        }
        this._answerButton.setMod('disabled', 'yes');
        this._skipButton.setMod('disabled', 'yes');
        this.findBlocksInside('checkbox').forEach(function (checkbox) {
            checkbox.setMod('disabled', 'yes');
        });
    },

    _enableControls: function () {
        if (this._radiobox) {
            this._radiobox.delMod('disabled');
        }
        this._answerButton.delMod('disabled');
        this._skipButton.delMod('disabled');
        this.findBlocksInside('checkbox').forEach(function (checkbox) {
            checkbox.delMod('disabled');
        });
    },

    /**
     * При выборе какого-либо значения, разблокируем кнопку ответа
     * @private
     */
    _onRadioboxChange: function () {
        this._answerButton.delMod('disabled');
    },

    /**
     * При выборе какого-либо значения, разблокируем кнопку ответа
     * Если ни один checkbox не выбран, заблокируем кнопку ответа
     * @private
     */
    _onCheckboxChange: function () {
        var checkedCheckboxes = this.findBlocksInside('checkbox').filter(function (checkbox) {
            return checkbox.isChecked();
        });

        this._answerButton.toggleMod('disabled', 'yes', !checkedCheckboxes.length);
    },

    /**
     * Инициализация попапа и привязка его к кнопке с иконкой вопросительного знака
     * @private
     */
    _initPopup: function () {
        this._popup = this.findBlockInside('popup2');
        this._helpButton = this.findElem('help-button');
        this._popup.setAnchor(this._helpButton);

        this.bindTo(this._helpButton, 'pointerclick', function () {
            this._popup.toggleMod('visible', 'yes');
        }.bind(this));
    },

    /**
     * Показывает спиннер
     * @private
     */
    _showSpinner: function () {
        BEM.DOM.destruct(this.findElem('help-button'));
        this._skipButton.destruct();

        var spinner = this.findElem('spin');

        if (!spinner) {
            return;
        }

        this._changeSpinnerMods(function (modName) {
            this.setMod(spinner, modName, 'yes');
        });
    },

    /**
     * Вспомогательный метод для показа / скрытия спиннера
     * @param {Function} cb
     * @private
     */
    _changeSpinnerMods: function (cb) {
        ['visible', 'progress'].forEach(cb, this);
    }
});
