module.exports = function (bh) {
    'use strict';

    bh.match('radiobox__radio', function (ctx, json) {
        var src = json.src;
        var badgeSize = json.badgeSize;
        var type = json.type;

        ctx.content([
            {
                elem: 'size',
                content: bh.lib.i18n('common', 'size.' + type)
            },
            {
                elem: 'picture',
                mods: { type: type },
                src: src,
                badgeSize: badgeSize,
                type: type
            }
        ]);
    });

    bh.match('radiobox__picture', function (ctx, json) {
        var src = json.src;
        var badgeSize = json.badgeSize;
        var type = json.type;

        ctx.content([
            {
                elem: 'img',
                mods: { type: type },
                attrs: {
                    src: src,
                    width: badgeSize.width,
                    height: badgeSize.height
                },
                tag: 'img'
            }
        ]);
    });
};
