module.exports = function (bh) {
    bh.match('region-switcher', function (ctx) {
        var global = bh.lib.global;
        var regions = global.regions;
        var currentRegion = regions[0];

        for (var i = 0, length = regions.length; i < length; i += 1) {
            if (regions[i].tld === global.tld) {
                currentRegion = regions[i];
                break;
            }
        }

        ctx.content({
            block: 'dropdown2',
            mods: {
                theme: 'normal',
                'has-tick': 'yes',
                size: ['m'],
                switcher: 'button2'
            },
            switcher: currentRegion.name,
            popup: {
                block: 'region-switcher',
                elem: 'popup',
                regions: regions,
                currentRegion: currentRegion
            }
        });
    });

    bh.match('region-switcher__popup', function (ctx, json) {
        ctx.content({
            block: 'b-menu-vert',
            content: json.regions.map(function (region) {
                if (json.currentRegion.tld === region.tld) {
                    return null;
                }

                return {
                    elem: 'item',
                    content: {
                        block: 'region-switcher',
                        elem: 'link',
                        region: region
                    }
                };
            })
        });
    });

    bh.match('region-switcher__link', function (ctx, json) {
        var region = json.region;

        ctx
            .tag('a')
            .attr('href', region.url)
            .content({
                elem: 'link-text',
                content: region.name
            });
    });
};
