/* global BEM, $ */
BEM.DOM.decl('scroll-to', {}, {
    _scrollElement: null,
    _options: {
        animationDuration: 300,
        offsetTop: 0 // высота отступа сверху
    },

    /**
     * Определяет позицию, к которой нужно проскроллить
     * на основе типа значения, которое пришло
     * @param {Block|jQuery|Number|String} value
     * @returns {Number}
     * @private
     */
    _getPosition: function (value) {
        // если пришло число, то сразу перемещаем
        if (typeof value === 'number') {
            return value;
        }

        // иначе это будет объект, у которого мы получим позицию
        var $elem;
        if (value instanceof BEM) {
            $elem = value.domElem;
        } else if (value instanceof $) {
            $elem = value;
        } else if (typeof value === 'string') {
            $elem = $(value);
        } else {
            // если это не Block, не jQuery-объект и
            // не строка-селектор, то скроллим вверх
            return 0;
        }

        // отдаем позицию объекта
        return $elem.offset().top;
    },

    /**
     * Устанавливает элемент для анимирования
     * @private
     */
    _setScrollElement: function () {
        var browser = BEM.blocks['i-global'].param('browser');

        if (this._scrollElement || !browser) {
            return;
        }

        this._scrollElement = $(browser.toLowerCase() === 'firefox' ? 'html' : 'body');
    },

    scrollTo: function (value, options, callback) {
        this._setScrollElement();

        if (this._scrollElement.is(':animated')) {
            return;
        }

        options = $.extend({}, this._options, options);

        this._scrollElement.animate(
            { scrollTop: this._getPosition(value) - options.offsetTop },
            options.animationDuration,
            callback
        );
    }
});
