module.exports = function (bh) {
    'use strict';
    bh.match('search-form', function (ctx, json) {
        ctx
            .js(true)
            .content([
                { elem: 'text' },
                {
                    elem: 'form',
                    cert: json.cert
                }
            ]);
    });

    bh.match('search-form__text', function (ctx) {
        ctx
            .mix({ block: 'html-content' })
            .content([
                bh.lib.i18n('common', 'certificates-search.description'),
                '<br>',
                bh.lib.i18n('common', 'certificates-search.invitation')
            ]);
    });

    bh.match('search-form__form', function (ctx, json) {
        var cert = json.cert;

        ctx.content([
            {
                elem: 'form-column',
                mods: { type: 'left' },
                content: {
                    elem: 'input',
                    type: 'certid',
                    placeholder: bh.lib.i18n('common', 'certificates-search.certid'),
                    value: cert && cert.certId
                }
            },
            {
                elem: 'form-column',
                content: {
                    elem: 'input',
                    type: 'lastname',
                    placeholder: bh.lib.i18n('common', 'certificates-search.lastname'),
                    value: cert && cert.lastname
                }
            },
            {
                elem: 'form-column',
                mods: { type: 'right' },
                content: {
                    elem: 'button',
                    disabled: cert
                }
            },
            {
                block: 'secret-key-input'
            }
        ]);
    });
};
