/* global BEM, BH, $ */
BEM.DOM.decl('search-form', {
    onSetMod: {
        js: function () {
            this._KEYCODES = BEM.blocks.keycodes;
            this._form = this.elem('form');
            this._inputs = {
                certId: this.findBlockInside(this._form, { block: 'input', modName: 'type', modVal: 'certid' }),
                lastname: this.findBlockInside(this._form, { block: 'input', modName: 'type', modVal: 'lastname' })
            };
            this._button = this.findBlockInside(this._form, 'button2');
            this._sk = this.findBlockInside(this._form, 'secret-key-input').domElem.val();

            this._bindEvents();
        }
    },

    _bindEvents: function () {
        BEM.blocks.input.on(this._form, 'change', this._onInputsChange.bind(this));
        this._inputs.certId.bindTo('keypress', this._onKeyPress.bind(this));
        this._inputs.lastname.bindTo('keypress', this._onKeyPress.bind(this));
        this._button.on('click', this._submit.bind(this));
    },

    _getData: function () {
        return {
            certId: this._inputs.certId.val(),
            lastname: this._inputs.lastname.val()
        };
    },

    _onInputsChange: function () {
        var data = this._getData();

        this._button.toggleMod('disabled', 'yes', !data.certId || !data.lastname);
    },

    _onKeyPress: function (e) {
        if (e.which === this._KEYCODES.ENTER && !this._button.hasMod('disabled', 'yes')) {
            this._submit();
        }
    },

    _submit: function () {
        this.trigger('submit', {
            data: this._getData(),
            sk: this._sk
        });
    },

    disableControls: function () {
        this._button.setMod('disabled', 'yes');
        this._inputs.certId.setMod('disabled', 'yes');
        this._inputs.lastname.setMod('disabled', 'yes');
    },

    enableControls: function () {
        this._button.delMod('disabled');
        this._inputs.certId.delMod('disabled');
        this._inputs.lastname.delMod('disabled');
    }
});
