module.exports = function (bh) {
    'use strict';
    bh.match('seo', function (ctx, json) {
        var seo = json.seo || {};
        var getMetaTag = function (content, attrs) {
            return content && {
                tag: 'meta',
                attrs: bh.utils.extend(attrs, { content: content })
            };
        };

        return [
            {
                tag: 'title',
                content: seo.title
            },
            getMetaTag(seo.description, { name: 'description' }),
            getMetaTag(seo.keywords, { name: 'keywords' }),
            getMetaTag(seo.ogTitle, { property: 'og:title' }),
            getMetaTag(seo.ogDescription, { property: 'og:description' }),
            getMetaTag(seo.ogUrl, { property: 'og:url' }),
            getMetaTag(seo.ogImage, { property: 'og:image' })
        ];
    });
};
