module.exports = function (bh) {
    'use strict';
    bh.match('share', function (ctx, json) {
        var socialList = bh.lib.global.socialList;

        if (!socialList) {
            return '';
        }

        var options = json.options || {};
        var attrs = {
            class: 'ya-share2',
            'data-services': socialList
        };

        for (var option in options) {
            if (options.hasOwnProperty(option)) {
                attrs['data-' + option] = options[option];
            }
        }

        ctx.content({ attrs: attrs });
    });
};
