module.exports = function (bh) {
    function getSidebarContent(content, phoneData, cta) {
        var phone = phoneData.phone;
        var text = phoneData.text;
        var hasCta = cta && cta.url;

        return [
            {
                elem: 'list-wrap',
                content: [
                    {
                        elem: 'list',
                        content: content
                    },
                    {
                        elem: 'footer',
                        content: [
                            (phone || text || hasCta) && {
                                elem: 'footer-advertising',
                                content: [
                                    hasCta && {
                                        elem: 'button',
                                        content: {
                                            block: 'button2',
                                            mods: {
                                                size: 'm',
                                                theme: 'action',
                                                width: 'max',
                                                type: 'link',
                                                cta: true
                                            },
                                            url: cta.url,
                                            text: cta.text ||
                                                bh.lib.i18n('products', 'order.button')
                                        }
                                    },
                                    {
                                        elem: 'footer-phone',
                                        content: [phone]
                                    },
                                    {
                                        elem: 'phone-description',
                                        content: [text]
                                    }
                                ]
                            },
                            {
                                elem: 'footer-location',
                                content: [
                                    { block: 'region-switcher' }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
    }

    bh.match('sidebar__content', function (ctx, json) {
        var menuItem = json.menuItem;
        var cta = json.cta;

        if (!menuItem.items || !menuItem.items.length) {
            return;
        }

        var content = menuItem.items.map(function (childMenuItem, index) {
            return {
                elem: 'item',
                mods: { current: childMenuItem.isCurrent },
                tag: 'a',
                attrs: {
                    href: childMenuItem.url || null,
                    name: index
                },
                content: [
                    Object.prototype.hasOwnProperty.call(childMenuItem, 'items') && {
                        elem: 'arrow'
                    },
                    childMenuItem.title
                ]
            };
        }, this);

        if (menuItem.parent) {
            content.unshift({
                elem: 'backward',
                content: [
                    {
                        elem: 'backward-arrow'
                    },
                    bh.lib.i18n('common', 'menu.backward')
                ]
            });
        }

        var sidebarContent = getSidebarContent(content, json.phoneData, cta);

        ctx.content(sidebarContent);
    });
};
