BEM.DOM.decl('sidebar', {
    /* eslint-disable max-statements */
    onSetMod: {
        js: function () {
            this._bPage = this.findBlockOutside('b-page');
            this._menu = this._bPage.findBlockInside('main-menu');
            this._headBlock = this._menu.findBlockInside('head');
            this._destructTimeout = 400;
            this._viewportHeight = BEM.DOM.win.innerHeight();
            this._prevPosition = window.pageYOffset;
            this._maxListMargin = -this._headBlock.domElem.height();
            this._initialCoords = 0;

            this._activeContent = null;
            this._activeListWrap = null;

            this.on('close', this._handleClose.bind(this));
            this.on('open', this._handleOpen.bind(this));

            this.bindToWin('scroll', this._handleScrollWin.bind(this));
            this.bindToWin('resize', $.debounce(this._onResize.bind(this), 300));

            this.bindTo(this.domElem, 'pointerclick', this._handleSidebarItemClick.bind(this));
            this.bindTo(this.domElem, 'pointerclick', this._handleBackwardClick.bind(this));

            // Не анимируем меню при открытии во время загрузки страницы
            setTimeout(this._setAnimatedMode.bind(this), 1000);

            this._bindMetrika();
        }
    },

    states: {
        default: 'default',
        fixedTop: 'fixedTop',
        fixedBottom: 'fixedBottom'
    },

    _defaultOffset: 130,

    _handleClose: function () {
        this._animateContent(false, this._activeContent, function () {
            this._activeListWrap = null;
            this._activeContent = null;
            this._listWrapHeight = 0;
            this._listWrapState = this.states.default;
        }.bind(this));

        this._destructContent(this._activeContent);
        this._slideContentBack();
    },

    _handleOpen: function (e, menuItem) {
        this._switchMenu(menuItem);
        this._slideContent();
    },

    _destructContent: function (content, cb) {
        setTimeout(function (currentContent) {
            BEM.DOM.destruct(currentContent);

            if (typeof cb === 'function') {
                cb();
            }
        }.bind(this, content), this._destructTimeout);
    },

    _addContent: function (menuItem, isActive) {
        BEM.DOM.append(this.domElem, BH.apply({
            block: 'sidebar',
            elem: 'content',
            menuItem: menuItem,
            mods: {
                active: isActive && 'yes',
                old: isActive && 'yes'
            },
            phoneData: this.params.phoneData,
            cta: this.params.cta
        }));

        this._activeContent = this.findElem('content').eq(-1);
        this._activeListWrap = this.findElem(this._activeContent, 'list-wrap');
        this._listWrapHeight = this._activeListWrap.height();

        this._listWrapState = this.states.default;
        this._updateListWrap();
        this._setSidebarOffset();
    },

    _animateContent: function (direction, content, cb) {
        this.afterCurrentEvent(function (targetContent) {
            if (direction) {
                this.setMod(targetContent, 'active', 'yes');
            } else {
                this.delMod(targetContent, 'active');
            }

            if (typeof cb === 'function') {
                cb();
            }

            this._setInitialSidebarMargin();
            this._handleAnimationEnd();
        }.bind(this, content));
    },

    _handleSidebarItemClick: function (e) {
        var $target = $(e.target);

        if (!$target.is(this.findElem('item'))) {
            return;
        }

        var targetName = $target.attr('name');
        var targetMenuItem = this.activeMenuItem.items[targetName];

        this._switchToSectionPage(e, targetMenuItem);

        var itemIsEmpty = this._targetItemIsEmpty(targetMenuItem);

        if (itemIsEmpty || targetMenuItem.switchToSectionPage) {
            return;
        }

        e.preventDefault();

        this._menu.trigger('breadcrumbs-push', targetName);
        this._switchMenu(targetMenuItem);
    },

    _handleBackwardClick: function (e) {
        var $target = $(e.target);

        if (!$target.is(this.findElem('backward'))) {
            return;
        }

        var targetMenuItem = this.activeMenuItem.parent;

        this._menu.trigger('breadcrumbs-back');

        this._switchMenuBackward(targetMenuItem);
    },

    _targetItemIsEmpty: function (targetMenuItem) {
        return !targetMenuItem ||
            !targetMenuItem.items ||
            !targetMenuItem.items.length;
    },

    _switchToSectionPage: function (e, targetMenuItem) {
        if (targetMenuItem.switchToSectionPage) {
            e.preventDefault();
            window.location.assign(targetMenuItem.url + '?menu=open');
        }
    },

    /**
     * Вычисляет верхний отступ сайдбара с учётом высоты
     * промежутка между сайдбаром и нижней границей вьюпорта.
     * @param {Number} offset
     * @returns {Number}
     * @private
     */
    _calculateOffset: function (offset) {
        var contentHeight = this._viewportHeight - this._listWrapHeight - offset;

        return offset + (contentHeight > 0 ? contentHeight : 0);
    },

    /**
     * Устанавливает верхний отступ для сайдбара.
     * @private
     */
    _setSidebarOffset: function () {
        var offset = this._calculateOffset(this._defaultOffset + this._getHeadMargin());

        if (this._listWrapState !== this.states.fixedTop) {
            this.delMod(this._activeContent, 'fixed');
            this._activeListWrap.css({ 'padding-top': window.pageYOffset + offset });
            this._listWrapState = this.states.default;
        }
    },

    _switchMenu: function (menuItem) {
        var oldContent = this._activeContent;

        this.setMod(oldContent, 'old', 'yes');
        this._addContent(menuItem);

        this._animateContent(true, this._activeContent, function () {
            if (oldContent) {
                this._destructContent(oldContent);
            }
        }.bind(this));

        this.activeMenuItem = menuItem;
    },

    _switchMenuBackward: function (menuItem) {
        var oldContent = this._activeContent;

        this._addContent(menuItem, true);

        this._animateContent(false, oldContent, function () {
            setTimeout(function () {
                if (oldContent) {
                    this._destructContent(oldContent);
                }

                this.delMod(this._activeContent, 'old');
            }.bind(this), this._destructTimeout);
        }.bind(this));

        this.activeMenuItem = menuItem;
    },

    _updateListWrap: function () {
        if (this._isSmallSidebar()) {
            this._updateSmallListWrap();
        } else {
            this._updateBiggerListWrap();
        }
    },

    _updateBiggerListWrap: function () {
        var direction = this._prevPosition <= window.pageYOffset;

        if (direction) {
            this._handleDownDirection();
        } else {
            this._handleUpDirection();
        }
    },

    _handleDownDirection: function () {
        if (this._listWrapState === this.states.fixedTop) {
            this.delMod(this._activeContent, 'fixed');
            this._menu.trigger('head-press');
            this._activeListWrap.css({ 'padding-top': window.pageYOffset + this._defaultOffset });
            this._listWrapState = this.states.default;

            return;
        }

        var offset = parseInt(this._activeListWrap.css('padding-top'), 10);

        if (this._listWrapState !== this.states.fixedBottom &&
            this._listWrapHeight + offset <= window.pageYOffset + this._viewportHeight
        ) {
            this._listWrapState = this.states.fixedBottom;
            this._activeListWrap.css({ 'padding-top': 0 });
            this.setMod(this._activeContent, 'fixed', 'bottom');

            return;
        }
    },

    _handleUpDirection: function () {
        if (this._listWrapState === this.states.fixedBottom) {
            this.delMod(this._activeContent, 'fixed');
            this._activeListWrap.css({
                'padding-top': window.pageYOffset + this._viewportHeight - this._listWrapHeight
            });
            this._listWrapState = this.states.default;

            return;
        }

        var offset = parseInt(this._activeListWrap.css('padding-top'), 10);

        if (this._listWrapState !== this.states.fixedTop &&
            offset - this._defaultOffset > window.pageYOffset
        ) {
            this._listWrapState = this.states.fixedTop;
            this._menu.trigger('head-down-press');
            this._activeListWrap.css({ 'padding-top': this._defaultOffset });
            this.setMod(this._activeContent, 'fixed', 'top');

            return;
        }
    },

    /**
     * Возвращает верхний отступ шапки.
     * @private
     * @returns {Number}
     */
    _getHeadMargin: function () {
        return parseInt(this._headBlock.domElem.css('margin-top'), 10);
    },

    /**
     * Устанавливает верхний отступ для элемента sidebar__list.
     * @param {jQuery} sidebarList
     * @param {Number} margin
     * @private
     */
    _setListMargin: function (sidebarList, margin) {
        if (sidebarList && this._isSmallSidebar()) {
            sidebarList.css('margin-top', margin);
            sidebarList.css('margin-bottom', -margin);
        }
    },

    /**
     * Устанавливает отступ для сайдбара при открытии меню или смене страницы.
     * @private
     */
    _setInitialSidebarMargin: function () {
        var margin = Math.max(this._getHeadMargin(), this._maxListMargin);
        var sidebarList = this._activeContent && this.findElem(this._activeContent, 'list');

        this._setListMargin(sidebarList, margin);
    },

    /**
     * Проверка, что все пункты меню видны на одном экране.
     * @private
     * @returns {Boolean}
     */
    _isSmallSidebar: function () {
        return this._listWrapHeight + this._defaultOffset <= this._viewportHeight;
    },

    _updateSmallListWrap: function () {
        if (this._listWrapState !== this.states.fixedTop) {
            this._listWrapState = this.states.fixedTop;
            this.setMod(this._activeContent, 'fixed', 'top');
        }

        var sidebarList = this._activeContent && this.findElem(this._activeContent, 'list');
        var pageYDifference = window.pageYOffset - this._prevPosition;
        var listMargin = parseInt(sidebarList.css('margin-top'), 10);
        var preparingListMargin = listMargin - pageYDifference;
        var newListMargin = BEM.blocks['main-menu'].normalizeMargin(preparingListMargin);

        this._setListMargin(sidebarList, newListMargin);
    },

    _onResize: function () {
        this._viewportHeight = BEM.DOM.win.innerHeight();
    },

    _setAnimatedMode: function () {
        this.setMod('animated', 'yes');
    },

    _bindMetrika: function () {
        var pageType = BH.lib.global.pageType;

        BEM.blocks.button2.on(this.domElem, 'click', function (e) {
            if (e.block.hasMod('cta')) {
                BEM.blocks.metrika.reachGoal('menu_cta_button_' + pageType);
            }
        });
    },

    _handleScrollWin: function () { /* Переопределено для платформы desktop */ },

    _handleAnimationEnd: function () { /* Переопределено для платформы touch */ },

    _slideContent: function () { /* Переопределено для платформы touch */ },

    _slideContentBack: function () { /* Переопределено для платформы touch */ }
});
