module.exports = function (bh) {
    bh.match('social', function (ctx) {
        var links = ctx.param('links');

        if (!Array.isArray(links) || !links.length) {
            return '';
        }

        var content = links.map(function (link) {
            var name = link.name;

            return {
                elem: 'item',
                mods: { name: name },
                url: link.url,
                name: name
            };
        });

        ctx.content(content);
    });

    bh.match('social__item', function (ctx) {
        ctx
            .tag('a')
            .attrs({
                title: bh.lib.i18n('common', ctx.param('name')),
                href: ctx.param('url'),
                target: '_blank'
            });
    });
};
