module.exports = function (bh) {
    'use strict';
    bh.match('table', function (ctx, json) {
        ctx
            .tag('table')
            .content([
                json.head && {
                    elem: 'head',
                    items: json.head
                },
                json.body && {
                    elem: 'body',
                    items: json.body
                }
            ]);

        return {
            elem: 'wrapper',
            content: [
                json.title && {
                    elem: 'title',
                    content: json.title
                },
                ctx.json()
            ]
        };
    });

    bh.match('table__head', function (ctx, json) {
        ctx
            .tag('thead')
            .content({
                tag: 'tr',
                content: json.items.map(function (item, index, array) {
                    var type;

                    if (index === 0) {
                        type = 'left';
                    } else if (index === (array.length - 1)) {
                        type = 'right';
                    }

                    return {
                        elem: 'th',
                        mods: { type: type },
                        text: item
                    };
                })
            });
    });

    bh.match('table__body', function (ctx, json) {
        ctx
            .tag('tbody')
            .content(json.items.map(function (item, index) {
                return {
                    elem: 'row',
                    mods: item.mods,
                    index: index,
                    items: item.content
                };
            }));
    });

    bh.match('table__row', function (ctx, json) {
        ctx
            .tag('tr')
            .mod('odd', !(json.index % 2) && 'yes')
            .content(json.items.map(function (item) {
                return {
                    tag: 'td',
                    content: item
                };
            }));
    });

    bh.match('table__th', function (ctx, json) {
        ctx
            .tag('th')
            .content({
                elem: 'head-text',
                content: json.text
            });
    });
};
