module.exports = function (bh) {
    'use strict';
    bh.match('usage', function (ctx, json) {
        ctx.content([
            {
                elem: 'title',
                mix: { block: 'content', elem: 'title' },
                content: bh.lib.i18n('common', 'usage.title')
            },
            json.usage && {
                elem: 'text',
                mix: { block: 'html-content' },
                content: bh.lib.util.template(json.usage.text)
            }
        ]);
    });

    bh.match('usage__title', function (ctx) {
        ctx.tag('h1');
    });
};
