module.exports = function (bh) {
    'use strict';
    bh.match('user__enter', function () {
        var title = bh.lib.i18n('common', 'user.enter');
        var authUrl = bh.lib.util.passport.getUrl();

        return [
            {
                block: 'button',
                url: authUrl,
                mods: { size: 's', theme: 'clear' },
                mix: [{ block: 'user', elem: 'enter' }],
                attrs: {
                    tabindex: '-1',
                    title: title,
                    'aria-label': title
                },
                content: [
                    {
                        block: 'user',
                        elem: 'enter-label'
                    }
                ]
            }
        ];
    });
};
