module.exports = function (bh) {
    'use strict';

    var TEN_HOURS_MS = 10 * 60 * 60 * 1000;
    var THREE_HOURS_MS = 3 * 60 * 60 * 1000;
    var LANGS_WITH_LOWERCASE_MONTHS = ['ru'];

    bh.lib.util = bh.lib.util || {};

    /**
     * Операции с датами и временем
     * @returns {Boolean}
     */
    bh.lib.util.date = {
        /**
         * По дате начала теста и продолжительности теста возвращает разницу в миллисекундах
         * @param {String|Date} started
         * @param {Number} limit
         * @returns {Number}
         */
        getTimeLeft: function (started, limit) {
            started = (started instanceof Date) ? started : new Date(started);
            var finishDate = new Date(started.getTime() + limit);
            var diff = finishDate - new Date();
            return (diff >= 0) ? diff : 0;
        },

        /**
         * Перeводит кол-во миллисекунд во время в формате H:MM:SS
         * Максимальное время, которое может быть обработано - 9h 59m 59s
         * @param {Number} milliseconds
         * @returns {String}
         */
        msToTime: function (milliseconds) {
            milliseconds = parseInt(milliseconds, 10);

            if (isNaN(milliseconds) || milliseconds >= TEN_HOURS_MS) {
                return '';
            }

            return new Date(milliseconds).toUTCString().replace(/.*\d(\d:\d{2}:\d{2}).*/, "$1");
        },

        /**
         * Переводит кол-во миллисекунд в дату в формате DD month YYYY
         * Например 259200000 -> 19 июня 2016
         * @param {Number} milliseconds
         * @returns {String}
         */
        humanizeDate: function (milliseconds) {
            var date = new Date(milliseconds);
            var month = bh.lib.i18n('i-tanker__months', 'g' + (date.getMonth() + 1));
            if (LANGS_WITH_LOWERCASE_MONTHS.indexOf(bh.lib.global.lang) > -1) {
                month = month.toLowerCase();
            }
            return date.getDate() + ' ' + month + ' ' + date.getFullYear();
        },

        /**
         * Переводит строковое представление даты в дату в формате DD.MM.YYYY
         * Например Tue Jun 28 2016 10:48:39 GMT+0500 (YEKT) -> 28.06.2016
         * @param {String} dateString
         * @returns {String}
         */
        dateStringToDate: function (dateString) {
            var dateFromDBInMs = new Date(dateString).getTime(); // кол-во мс в базе в UTC
            var dateInMoscowTimezone = dateFromDBInMs + THREE_HOURS_MS; // переводим дату в Europe/Moscow
            var date = new Date(dateInMoscowTimezone);

            var month = (1 + date.getMonth()).toString();
            month = month.length > 1 ? month : '0' + month;
            var day = date.getDate().toString();
            day = day.length > 1 ? day : '0' + day;
            return day + '.' + month + '.' + date.getFullYear();
        },

        /**
         * Перeводит кол-во миллисекунд в минуты
         * @param {Number} milliseconds
         * @returns {Number}
         */
        msToMinutes: function (milliseconds) {
            milliseconds = parseInt(milliseconds, 10);

            if (isNaN(milliseconds)) {
                return 0;
            }

            return Math.ceil(milliseconds / 60 / 1000);
        }
    };
};
