module.exports = function (bh) {
    'use strict';

    var handlers = {
        form: function (id) {
            return bh.apply({
                block: 'iframe-form',
                formId: id
            });
        },
        pseudolink: function (text) {
            return bh.apply({
                block: 'link',
                mods: {
                    theme: 'pseudo',
                    pseudo: 'yes'
                },
                content: text
            });
        },
        img: function (url) {
            var isMobile = bh.lib.global.isMobile;
            var image = {
                block: 'image',
                mods: { type: 'question' },
                url: url
            };
            var content = isMobile ? {
                tag: 'a',
                attrs: { target: '_blank', href: url },
                content: image
            } : image;

            return bh.apply(content);
        },
        link: function (url, text) {
            return bh.apply({
                block: 'link',
                mods: { theme: 'normal' },
                text: text || url,
                url: url,
                target: 'blank'
            });
        }
    };

    /**
     * Ищет и заменяет плэйсхолдеры в текстах из Бункера
     * Синтаксис плэйсхолдеров: {{type:arg|text}}
     * text используется для плэйсхолдера link
     * @returns {String}
     */
    bh.lib.util.template = function (string) {
        return string.replace(/{{(\w+)(?::([^|]+))?(?:\|([^}]+))?}}/g, function (str, type, arg, text) {
            if (handlers.hasOwnProperty(type)) {
                return handlers[type](arg, text) || '';
            }
            return str;
        });
    };
};
