module.exports = function (bh) {
    bh.match('attempt-result__read-rules', function (ctx, json) {
        if (json.status !== 'failed' || json.isWaitingForRevision) {
            return '';
        }

        ctx.content([
            {
                tag: 'h3',
                elem: 'rules-text',
                content: bh.lib.i18n('common', 'exam.proctoring.rules-again')
            },
            {
                elem: 'rules-button',
                content: {
                    block: 'button2',
                    mods: {
                        theme: 'action',
                        type: 'link',
                        size: 'm'
                    },
                    url: json.rulesUrl,
                    text: bh.lib.i18n('common', 'exam.proctoring.rules-again.button')
                }
            }
        ]);
    });
};
