module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./attempt-result-mock');

        return {
            block: blockName,
            content: {
                block: 'size-wrapper',
                width: 600,
                content: [
                    {
                        block: 'size-wrapper',
                        mods: { type: 'cert' },
                        content: {
                            block: 'attempt-result',
                            mods: { type: 'cert' },
                            data: data.certificate
                        }
                    },
                    {
                        block: 'size-wrapper',
                        mods: { type: 'achievement' },
                        content: {
                            block: 'attempt-result',
                            mods: { type: 'achievement' },
                            data: data.achievement
                        }
                    },
                    {
                        block: 'size-wrapper',
                        mods: { proctoring: 'pending' },
                        content: {
                            block: 'attempt-result',
                            mods: { type: 'cert' },
                            data: data.pendingProctoring
                        }
                    },
                    {
                        block: 'size-wrapper',
                        mods: { proctoring: 'failed' },
                        content: {
                            block: 'attempt-result',
                            mods: { type: 'cert' },
                            data: data.failedProctoring
                        }
                    }
                ]
            }
        };
    });
};
