module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./cert-info-mock.json');

        return {
            block: blockName,
            content: [
                {
                    block: 'size-wrapper',
                    width: 600,
                    attrs: { style: 'padding-top: 20px;' },
                    mods: { type: 'active' },
                    content: {
                        block: 'cert-info',
                        cert: data.active
                    }
                },
                {
                    block: 'size-wrapper',
                    width: 600,
                    attrs: { style: 'padding-top: 20px;' },
                    mods: { type: 'inactive' },
                    content: {
                        block: 'cert-info',
                        cert: data.inactive
                    }
                },
                {
                    block: 'size-wrapper',
                    width: 600,
                    attrs: { style: 'padding-top: 20px;' },
                    mods: { type: 'collapsible-active' },
                    content: {
                        block: 'cert-info',
                        mods: { collapsible: 'yes' },
                        cert: data.active
                    }
                },
                {
                    block: 'size-wrapper',
                    width: 600,
                    attrs: { style: 'padding: 20px 16px;' },
                    mods: { type: 'collapsible-inactive' },
                    content: {
                        block: 'cert-info',
                        mods: { collapsible: 'yes' },
                        cert: data.inactive
                    }
                }
            ]
        };
    });
};
