module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./cert-preview-mock.json');

        return {
            block: blockName,
            content: [
                {
                    block: 'size-wrapper',
                    width: 600,
                    mods: { layout: 'old' },
                    content: {
                        block: 'cert-preview',
                        isOldDesign: true,
                        cert: data.old_design,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    width: 600,
                    mods: { layout: 'initials' },
                    content: {
                        block: 'cert-preview',
                        cert: data.new_design,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    width: 600,
                    mods: { cert: 'pending' },
                    content: {
                        block: 'cert-preview',
                        cert: data.pending
                    }
                }
            ]
        };
    });
};
