module.exports = function (bh) {
    'use strict';

    bh.match('cert-share__share', function (ctx, json) {
        ctx.content([{
            block: 'share',
            options: json.options
        }]);
    });

    bh.match('cert-share__download', function (ctx, json) {
        ctx.content({
            block: 'button2',
            mods: {
                type: 'link',
                theme: 'normal',
                size: 'm'
            },
            url: json.url,
            text: bh.lib.i18n('common', 'cert.download'),
            target: '_blank'
        });
    });

    bh.match('cert-share__get-code', function (ctx) {
        ctx.content({
            block: 'button2',
            mods: {
                theme: 'normal',
                size: 'm'
            },
            text: bh.lib.i18n('cert', 'get-code')
        });
    });

    bh.match('cert-share__popup', function (ctx, json) {
        var certPopupSrc = json.certPopupSrc;
        var certTitle = json.certTitle;
        var certPopupSize = json.certPopupSize;

        ctx.content([
            {
                block: 'popup2',
                mods: {
                    target: 'position',
                    theme: 'normal',
                    visible: 'no'
                },
                content: {
                    elem: 'cert-popup',
                    tag: 'img',
                    attrs: {
                        src: certPopupSrc,
                        alt: certTitle,
                        title: certTitle,
                        width: certPopupSize && certPopupSize.width,
                        height: certPopupSize && certPopupSize.height
                    }
                }
            }
        ]);
    });
};
