module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./certificates-search-mock.json');

        return {
            block: blockName,
            content: [
                {
                    block: 'i-global',
                    params: {
                        browser: 'YandexBrowser',
                        isMobile: false
                    }
                },
                {
                    block: 'size-wrapper',
                    width: 800,
                    mods: { type: 'empty' },
                    content: {
                        block: 'certificates-search'
                    }
                },
                {
                    block: 'size-wrapper',
                    width: 800,
                    mods: { type: 'filled' },
                    content: {
                        block: 'certificates-search',
                        cert: data.filled
                    }
                },
                {
                    block: 'size-wrapper',
                    width: 800,
                    mods: { type: 'wrong' },
                    content: {
                        block: 'certificates-search',
                        cert: data.wrong
                    }
                }
            ]
        };
    });
};
