module.exports = function (bh) {
    bh.match('check-hardware', function (ctx, json) {
        var steps = json.steps;
        if (!steps || steps.length === 0) {
            return '';
        }

        ctx
            .js(true)
            .content(steps.map(function (step) {
                return {
                    elem: 'step',
                    mods: {
                        type: step.name
                    },
                    content: [
                        {
                            elem: 'title',
                            content: step.title
                        },
                        {
                            elem: 'error'
                        }
                    ]
                };
            }));
    });
};
