BEM.DOM.decl('check-hardware', {
    getSteps: function () {
        return this.findElem('step');
    },

    getStepType: function (step) {
        var stepElem = this.elemify(step);

        return this.getMod(stepElem, 'type');
    },

    setProgressState: function (step) {
        var stepElem = this.elemify(step);

        this.setMod(stepElem, 'state', 'progress');
    },

    setSuccessState: function (step) {
        var stepElem = this.elemify(step);

        this.setMod(stepElem, 'state', 'success');
    },

    getErrorText: function (error, checkData) {
        var errMatch = error.match(/.*?\s(\w+)/);

        var errName = errMatch && errMatch[1] ? errMatch[1] : null;
        var detailedError = checkData.detailedErrors.filter(function (errorData) {
            return errorData.name === errName;
        })[0];

        return detailedError ? detailedError.text : checkData.error;
    },

    setFailedState: function (step, error, checkData) {
        var stepElem = this.elemify(step);
        var errorElem = this.findElem(stepElem, 'error');
        var errorText = this.getErrorText(error, checkData);

        var newErrorElem = BH.apply({
            block: 'check-hardware',
            elem: 'error',
            content: errorText
        });

        BEM.DOM.replace(errorElem, newErrorElem);

        this.setMod(stepElem, 'state', 'failed');
        this.delMod(errorElem, 'disabled');
    }
});
